% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{wb_country_indicator}
\alias{wb_country_indicator}
\title{World Bank country indicator data}
\source{
\url{http://api.worldbank.org/v2/country/{country}/indicator/{indicator}}
}
\usage{
wb_country_indicator(
  indicator = "NY.GDP.MKTP.CD",
  country = NULL,
  lang = "en",
  start_year = NULL,
  end_year = NULL
)
}
\arguments{
\item{indicator}{\code{character(1)} indicator to query.}

\item{country}{\code{character()} country to query. Default \code{NULL}.
If \code{NULL}, all countries are returned.}

\item{lang}{\code{character(1)} language to query. Default \code{"en"}.}

\item{start_year}{\code{integer(1)} start year to query. Default \code{NULL}.}

\item{end_year}{\code{integer(1)} end year to query. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with the available country indicators.
The columns are:
\item{date}{The date}
\item{indicator_id}{The indicator ID.}
\item{indicator_name}{The indicator name.}
\item{country_id}{The country ID.}
\item{country_name}{The country name.}
\item{country_code}{The country code.}
\item{value}{The indicator value.}
\item{unit}{The indicator unit.}
\item{obs_status}{The observation status.}
\item{decimal}{The decimal.}
}
\description{
List all country indicators supported by the World Bank API.
}
\examples{
wb_country_indicator("NY.GDP.MKTP.CD", "US")
}
