% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordbankr.R
\name{get_item_data}
\alias{get_item_data}
\title{Get the Wordbank by-item data}
\usage{
get_item_data(language = NULL, form = NULL, mode = "remote")
}
\arguments{
\item{language}{An optional string specifying which language's items to
retrieve.}

\item{form}{An optional string specifying which form's items to retrieve.}

\item{mode}{A string indicating connection mode: one of \code{"local"},
or \code{"remote"} (defaults to \code{"remote"})}
}
\value{
A data frame where each row is a CDI item and each column is a
  variable about it (\code{language}, \code{form}, \code{type},
  \code{lexical_category}, \code{category}, \code{uni_lemma}, \code{item},
  \code{definition}, \code{num_item_id}).
}
\description{
Get the Wordbank by-item data
}
\examples{
\dontrun{
english_ws_items <- get_item_data("English", "WS")
all_items <- get_item_data()
}
}

