% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{viewshed}
\alias{viewshed}
\title{Calculate visibility}
\usage{
viewshed(r, shape, turbine_locs, h1 = 0, h2 = 0)
}
\arguments{
\item{r}{A DEM raster}

\item{shape}{A SpatialPolygon of the windfarm area.}

\item{turbine_locs}{Coordinates or SpatialPoint representing the wind
turbines}

\item{h1}{A numeric giving the extra height offset of Point 1}

\item{h2}{A numeric giving the extra height offset of Point 2}
}
\value{
A list of 5, containing the boolean result for every cell, the raster
  cell points, a SimpleFeature Polygon of the given area and the DEM raster
}
\description{
Calculate visibility for given points in a given area.
}
\examples{
\dontrun{
library(sp)
Polygon1 <- Polygon(rbind(c(4488182, 2667172), c(4488182, 2669343),
                          c(4499991, 2669343), c(4499991, 2667172)))
Polygon1 <- Polygons(list(Polygon1), 1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
DEM_meter <- getDEM(Polygon1)

turbloc = spsample(DEM_meter[[2]], 10, type = "random");
res <- viewshed(r = DEM_meter[[1]], shape=DEM_meter[[2]], turbine_locs = turbloc,  h1=1.8, h2=50)
}
}
\seealso{
Other Viewshed Analysis: \code{\link{cansee}},
  \code{\link{interpol_view}}, \code{\link{plot_viewshed}},
  \code{\link{rasterprofile}}, \code{\link{viewTo}}
}
\concept{Viewshed Analysis}
