% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfitnessevolution.R
\name{plotfitnessevolution}
\alias{plotfitnessevolution}
\title{Plot the changes of min/mean/max fitness values}
\usage{
plotfitnessevolution(result, spar = 0.1)
}
\arguments{
\item{result}{An output matrix of the function \code{\link{windfarmGA}}
or \code{\link{genAlgo}} which has stored all relevant information.
(matrix)}

\item{spar}{A numeric value determining how exact a spline should
be drawn. Default is 0.1 (numeric)}
}
\description{
Plot the evolution of fitness values and the change in the
min, mean and max fitness values to the former generations.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
result <- resulthex
plotfitnessevolution(result, 0.1)
}
}
\author{
Sebastian Gatscha
}
