% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitness}
\alias{fitness}
\title{Evaluate the Individual Fitness values}
\usage{
fitness(selection, referenceHeight, RotorHeight, SurfaceRoughness, Polygon,
  resol1, rot, dirspeed, srtm_crop, topograp, cclRaster, weibull, weibullsrc)
}
\arguments{
\item{selection}{A list containing all individuals of the current
population. (list)}

\item{referenceHeight}{The height at which the incoming wind speeds were
measured. (numeric)}

\item{RotorHeight}{The desired height of the turbine. (numeric)}

\item{SurfaceRoughness}{A surface roughness length of the considered area
in m. (numeric)}

\item{Polygon}{The considered area as shapefile. (SpatialPolygons)}

\item{resol1}{The resolution of the grid in meter. (numeric)}

\item{rot}{The desired rotor radius in meter. (numeric)}

\item{dirspeed}{The wind speed and direction data.frame. (data.frame)}

\item{srtm_crop}{Logical value that indicates whether the terrain effect
model is activated (TRUE) or deactivated (FALSE). (logical)}

\item{topograp}{Logical value that indicates whether the terrain effect
model is activated (TRUE) or deactivated (FALSE). (logical)}

\item{cclRaster}{A Corine Land Cover raster, that has to be adapted
previously by hand with the surface roughness lenght for every land cover
type. Is only used, when the terrain effect model is activated. (raster)}

\item{weibull}{A logical value that specifies whether to take Weibull
parameters into account. If weibull==TRUE, the wind speed values from the
'dirSpeed' data frame are ignored. The algorithm will calculate the mean
wind speed for every wind turbine according to the Weibull parameters.
(logical)}

\item{weibullsrc}{A list of Weibull parameter rasters, where the first list
item must be the shape parameter raster k and the second item must be the
scale parameter raster a of the Weibull distribution. If no list is given,
then rasters included in the package are used instead, which currently
only cover Austria. This variable is only used if weibull==TRUE. (list)}
}
\value{
Returns a list with every individual, consisting of X & Y
coordinates, rotor radii, the runs and the selected grid cell IDs, and
the resulting energy outputs, efficiency rates and fitness values.
(list)
}
\description{
The fitness values of the individuals in the
current population are calculated after having evaluated their energy
outputs in \code{\link{calculateEn}}. This function reduces the resulting
energy outputs to a single fitness value for every individual.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                    c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
plot(Polygon1,axes=TRUE)

## Create a uniform and unidirectional wind data.frame and plots the
## resulting wind rose
## Uniform wind speed and single wind direction
data.in <- as.data.frame(cbind(ws=12,wd=0))
# windrosePlot <- plotWindrose(data = data.in, spd = data.in$ws,
#                dir = data.in$wd, dirres=10, spdmax=20)

## Calculate a Grid and an indexed data.frame with coordinates and
## grid cell Ids.
Grid1 <- GridFilter(shape = Polygon1,resol = 200,prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

startsel <- StartGA(Grid,10,20);
wind <- as.data.frame(cbind(ws=12,wd=0))
fit <- fitness(selection = startsel, referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="", topograp=FALSE, cclRaster="")
head(fit)

## Calculate fitness values with the Weibull parameters included in the
## package. Only available for Austria.
fit <- fitness(selection = startsel,referenceHeight = 100, RotorHeight=100,
              SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
              dirspeed = wind, srtm_crop="",topograp=FALSE,cclRaster="",
              weibull=T)
head(fit)

## Calculate fitness values with given Weibull rasters.
library(raster)
araster <-  "...path.to.../scale_param_weibull.tif"
kraster <- "...path.to.../shape_param_weibull.tif"
weibullrasters <- list(raster(kraster), raster(araster))

fit <- fitness(selection = startsel,referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="",topograp=FALSE,cclRaster="",
               weibull=T, weibullsrc = weibullrasters)
head(fit)
}

}
\author{
Sebastian Gatscha
}
