% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfitnessevolution.R
\name{plotfitnessevolution}
\alias{plotfitnessevolution}
\title{Plot the changes of min/mean/max fitness values}
\usage{
plotfitnessevolution(result, spar = 0.1)
}
\arguments{
\item{result}{An output matrix of the function \code{\link{windfarmGA}}
or \code{\link{genAlgo}} which has stored all relevant information.
(matrix)}

\item{spar}{A numeric value determining how exact a spline should
be drawn. Default is 0.1 (numeric)}
}
\description{
Plot the evolution of fitness values and the change in the
min, mean and max fitness values to the former generations.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(0, 0), c(0, 2000), c(2000, 2000), c(2000, 0)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
plot(Polygon1,axes=TRUE)

## Create a uniform and unidirectional wind data.frame and plots the
## resulting wind rose
## Uniform wind speed and single wind direction
data.in <- as.data.frame(cbind(ws=12,wd=0))
# windrosePlot <- plotWindrose(data = data.in, spd = data.in$ws,
#                dir = data.in$wd, dirres=10, spdmax=20)

## Runs an optimization run for 10 iterations (iteration) with the
## given shapefile (Polygon1), the wind data.frame (data.in),
## 12 turbines (n) with rotor radii of 30m (Rotor) and a grid spacing
## factor of 3 (fcrR) and other required inputs.
result <- genAlgo(Polygon1 = Polygon1, n=12, Rotor=20,fcrR=3,iteration=10,
             vdirspe = data.in,crossPart1 = "EQU",selstate="FIX",mutr=0.8,
            Proportionality = 1, SurfaceRoughness = 0.3, topograp = FALSE,
            elitism=TRUE, nelit = 7, trimForce = TRUE,
            referenceHeight = 50,RotorHeight = 100)
plotfitnessevolution(result, 0.1)
}
}
\author{
Sebastian Gatscha
}
