% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightFun.R
\name{weightFun}
\alias{weightFun}
\title{weight function}
\usage{
weightFun(
  x,
  propTable,
  type,
  typeCol,
  distanceCol,
  propCol,
  xFun = ceiling,
  maxDistance = NULL,
  ...
)
}
\arguments{
\item{x}{Numeric vector.}

\item{propTable}{Data frame contain the proportion of area searched by distance and plot type.}

\item{type}{Character, indicating which plot type to subset \code{propTable}.}

\item{typeCol}{Character, column name of the plot type in \code{propTable}.}

\item{distanceCol}{Character, column name of the distance in \code{propTable}.}

\item{propCol}{Character, column name of the proportion of area searched in \code{propTable}.}

\item{xFun}{Function, default is \code{\link[base]{ceiling}}, see details.}

\item{maxDistance}{Numeric, default is \code{NULL}. If a value is given then \code{propTable} is subsetted to where \code{propTable[,distanceCol] <= maxDistance}.}

\item{...}{Additional arguments passed to \code{xFun}.}
}
\value{
Numeric vector of weights with length equal to \code{length(x)}, and with a 1:1 relationship to the values in \code{x}.
}
\description{
Generic weight function for use with \code{\link{estWD}}.
}
\details{
The \code{\link{weightedDistribution}} function requires the weights be described using a function.
This allows integration to happen.

Typically \code{propTable} has integer values for the distances, but the function needs to take in any numeric values, the \code{xFun} function is how any numeric value can be matched up to the values in \code{propTable}.
If the distances in \code{propTable} correspond to the outer radius of the annuli, for calculating proportion of area searched, then the \code{\link[base]{ceiling}} is appropriate.
If the distances in \code{propTable} correspond to the inner radius of the annuli then the \code{\link[base]{floor}} might be more appropriate.
}
\examples{

data(proportionAreaSearched)

d <- c(-300.23,14.3,16,75)

## RP proportion of area searched
weightFun(x=d,propTable=proportionAreaSearched,type='RP',typeCol='plotType',
distanceCol='distanceFromTurbine',propCol='proportionAreaSearched')
#[1] 0.00000000 0.08896480 0.08308577 0.01709869

## FULL plot proportion of area searched
weightFun(x=d,propTable=proportionAreaSearched,type='FULL',typeCol='plotType',
distanceCol='distanceFromTurbine',propCol='proportionAreaSearched')
# [1] 0 1 1 1

### with a max distance restriction
## RP proportion of area searched
weightFun(x=d,propTable=proportionAreaSearched,type='RP',typeCol='plotType',
distanceCol='distanceFromTurbine',propCol='proportionAreaSearched',maxDistance=40)
# [1] 0.00000000 0.08896480 0.08308577 0.00000000

## FULL plot proportion of area searched
weightFun(x=d,propTable=proportionAreaSearched,type='FULL',typeCol='plotType',
distanceCol='distanceFromTurbine',propCol='proportionAreaSearched',maxDistance=40)
# [1] 0 1 1 0


}
\seealso{
\code{\link{estWD}}
}
