% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prox.R
\name{Prox}
\alias{Prox}
\title{Proximity Index}
\usage{
Prox(traj, traj2, tc = 0, dc = 50, local = FALSE)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when two fixes are spatially together.}

\item{local}{logical value indicating. When local = FALSE (the default) prox returns a data.frame with the global proximity ratio (proportion of all fixes below dc and tc) for each pair of individuals. When local = TRUE, prox returns the input move2 object with the distance to the most proximal fix, and the number of fixes that are considered proximal for each fix in the dataset.}
}
\value{
If \code{local=FALSE} (the default) Prox returns the numeric value of the Prox index for each pair of individuals.
If \code{local=TRUE} Prox returns a \code{move2} containing the original trajectory (or both trajectories) with three additional columns prox (the distance to the nearest proximal fix), prox.id (the id of the nearest proximal fix) and prox.n (the number of individuals with proximal fixes)
}
\description{
The function \code{Prox} simply computes the proportion of (simultaneous) fixes that are proximal, based on some spatial
threshold -- \code{dc} (Bertrand et al. 1996). It also facilitates local-level proximity analysis
}
\details{
The function \code{Prox} can be used to test for the presence of attraction (via proximity) in wildlife telemetry data. Prox is simply the proportion of simultaneous fixes within the threshold distance -- \code{dc}. The local output (dataframe) can be useful for examining variation in proximity through time.
}
\examples{
data(deer)
#tc = 7.5 minutes, dc = 50 meters
Prox(deer, tc=7.5*60, dc=50)
deer <- Prox(deer, tc=7.5*60, dc=50, local=TRUE)

}
\references{
Bertrand, M.R., DeNicola, A.J., Beissinger, S.R, Swihart, R.K. (1996) Effects of parturition
on home ranges and social affiliations of female white-tailed deer.
\emph{Journal of Wildlife Management}, \bold{60}: 899-909.
}
\seealso{
GetSimultaneous, contacts
}
\keyword{indices}
