% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wkt_correct}
\alias{wkt_correct}
\title{Correct Incorrectly Oriented WKT Objects}
\usage{
wkt_correct(x)
}
\arguments{
\item{x}{a character vector of WKT objects to correct}
}
\value{
a character vector, the same length as \code{x}, containing
either the original value (if there was no correction to make, or if
the object was invalid for other reasons) or the corrected WKT
value.
}
\description{
\code{wkt_correct} does precisely what it says on the tin,
correcting the orientation of WKT objects that are improperly oriented
(say, back to front). It can be applied to WKT objects that,
when validated with \code{\link{validate_wkt}}, fail for that reason.
}
\examples{

# A WKT object
wkt <- "POLYGON((30 20, 10 40, 45 40, 30 20), (15 5, 5 10, 10 20, 40 10, 15 5))"

# That's invalid due to a non-default orientation
validate_wkt(wkt)

# And suddenly isn't!
wkt_correct(wkt)
}
