% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averages.R
\name{perform_average}
\alias{perform_average}
\title{Perform average on second-by-second data}
\usage{
perform_average(
  .data,
  type = c("bin", "rolling", "ensemble"),
  bins = 30,
  rolling_window = 30
)
}
\arguments{
\item{.data}{The second-by-second data retrieved from \code{interpolate()}.}

\item{type}{The type of the average to perform. Either \code{bin}, \code{rolling}, or \code{ensemble}.}

\item{bins}{If bin-average is chosen, here you can specify the size of the bin-average, in seconds. Default to 30-s bin-average.}

\item{rolling_window}{If rolling-average is chosen, here you can specify the rolling-average window, in seconds. Default to 30-s rolling-average.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
This function performs either a bin- or a rolling-average on the interpolated data.
You must specify the \code{type} of the average before continuing.
}
\details{
Ensemble average is used in VO2 kinetics analysis, where a series of transitions from baseline to
the moderate/heavy/severe intensity-domain is ensembled averaged into a single 'bout' for further data processing.
}
\examples{
\dontrun{
## get file path from example data
path_example <- system.file("example_cosmed.xlsx", package = "whippr")

## read data
df <- read_data(path = path_example, metabolic_cart = "cosmed")

## interpolate and perform 30-s bin-average
df \%>\%
 interpolate() \%>\%
 perform_average(type = "bin", bins = 30)

## interpolate and perform 30-s rolling-average
df \%>\%
 interpolate() \%>\%
 perform_average(type = "rolling", rolling_window = 30)
}
}
