% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multilinestring.R
\name{multilinestring}
\alias{multilinestring}
\title{Make WKT multilinestring objects}
\usage{
multilinestring(..., fmt = 16)
}
\arguments{
\item{...}{A GeoJSON-like object representing a Point, LineString, Polygon,
multilinestring, etc.}

\item{fmt}{Format string which indicates the number of digits to display after the
decimal point when formatting coordinates. Max: 20}
}
\description{
Make WKT multilinestring objects
}
\details{
There is no \code{numeric} input option for multilinestring. There is no
way as of yet to make a nested multilinestring with \code{data.frame} input, but you
can do so with list input. See examples.
}
\examples{
## empty multilinestring
multilinestring("empty")
# multilinestring("stuff")

# character string
x <- "MULTILINESTRING ((30 20, 45 40, 10 40), (15 5, 40 10, 10 20))"
multilinestring(x)

# data.frame
df <- data.frame(long = c(30, 45, 10), lat = c(20, 40, 40))
df2 <- data.frame(long = c(15, 40, 10), lat = c(5, 10, 20))
multilinestring(df, df2, fmt=0)
multilinestring(df, df2, fmt=0) \%>\% lint
multilinestring(df, df2) \%>\% wktview(zoom=3)

# matrix
mat <- matrix(c(df$long, df$lat), ncol = 2)
mat2 <- matrix(c(df2$long, df2$lat), ncol = 2)
multilinestring(mat, mat2, fmt=0)

# list
x1 <- list(c(30, 20), c(45, 40), c(10, 40))
x2 <- list(c(15, 5), c(40, 10), c(10, 20))
multilinestring(x1, x2, fmt=2)

polys <- list(
  list(c(30, 20), c(45, 40), c(10, 40)),
  list(c(15, 5), c(40, 10), c(10, 20))
)
multilinestring(polys, fmt=2) \%>\%
  wktview(zoom=3)
}
\seealso{
Other R.objects: \code{\link{circularstring}};
  \code{\link{geometrycollection}};
  \code{\link{linestring}}; \code{\link{multipoint}};
  \code{\link{multipolygon}}; \code{\link{point}};
  \code{\link{polygon}}
}

