% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playercompare}
\alias{wnba_playercompare}
\title{\strong{Get WNBA Stats API Player Compare}}
\usage{
wnba_playercompare(
  conference = "",
  date_from = "",
  date_to = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "10",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  player_id_list = "100720,202250,204319,1627668,1628931",
  plus_minus = "N",
  rank = "N",
  season = most_recent_wnba_season(),
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  vs_conference = "",
  vs_division = "",
  vs_player_id_list = "202252,203399,1631022,1628878,204333",
  ...
)
}
\arguments{
\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_id_list}{Player ID}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{Season - format 2020-21}

\item{season_segment}{season_segment}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{shot_clock_range}{shot_clock_range}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{vs_player_id_list}{vs_player_id_list}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: Individual, OverallCompare

\strong{OverallCompare}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   DESCRIPTION \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
}


\strong{Individual}\tabular{ll}{
   col_name \tab types \cr
   GROUP_SET \tab character \cr
   DESCRIPTION \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   TOV \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   BLKA \tab character \cr
   PF \tab character \cr
   PFD \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Compare}

\strong{Get WNBA Stats API Player Compare}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_playercompare(player_id_list = '100720,202250,204319,1627668,1628931', vs_player_id_list = '202252,203399,1631022,1628878,204333')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
