% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_boxscore_v3.R
\name{wnba_gamerotation}
\alias{wnba_gamerotation}
\title{\strong{Get WNBA Stats API Game Rotation}}
\usage{
wnba_gamerotation(game_id, league_id = "10", rotation_stat = "PLAYER_PTS", ...)
}
\arguments{
\item{game_id}{Game ID}

\item{league_id}{League ID}

\item{rotation_stat}{Rotation stat to provide details on: PLAYER_PTS, PT_DIFF, USG_PCT}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: AwayTeam, HomeTeam

\strong{AwayTeam}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   PERSON_ID \tab character \cr
   PLAYER_FIRST \tab character \cr
   PLAYER_LAST \tab character \cr
   IN_TIME_REAL \tab character \cr
   OUT_TIME_REAL \tab character \cr
   PLAYER_PTS \tab character \cr
   PT_DIFF \tab character \cr
   USG_PCT \tab character \cr
}


\strong{HomeTeam}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   PERSON_ID \tab character \cr
   PLAYER_FIRST \tab character \cr
   PLAYER_LAST \tab character \cr
   IN_TIME_REAL \tab character \cr
   OUT_TIME_REAL \tab character \cr
   PLAYER_PTS \tab character \cr
   PT_DIFF \tab character \cr
   USG_PCT \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Game Rotation}

\strong{Get WNBA Stats API Game Rotation}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_gamerotation(game_id = "1022200034")
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Boxscore Functions: 
\code{\link{wnba_boxscoreadvancedv2}()},
\code{\link{wnba_boxscorefourfactorsv2}()},
\code{\link{wnba_boxscoremiscv2}()},
\code{\link{wnba_boxscoreplayertrackv2}()},
\code{\link{wnba_boxscorescoringv2}()},
\code{\link{wnba_boxscoresummaryv2}()},
\code{\link{wnba_boxscoretraditionalv2}()},
\code{\link{wnba_boxscoreusagev2}()},
\code{\link{wnba_hustlestatsboxscore}()}

Other WNBA Lineup Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguelineupviz}()},
\code{\link{wnba_shotchartlineupdetail}()},
\code{\link{wnba_teamdashlineups}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Boxscore Functions}
\concept{WNBA Lineup Functions}
