% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestPattern.R
\name{UriPattern}
\alias{UriPattern}
\title{UriPattern}
\description{
uri matcher
}
\examples{
# trailing slash
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com")
z$matches("http://foobar.com/")

# default ports
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com:80")
z$matches("http://foobar.com:80/")
z$matches("http://foobar.com:443")
z$matches("http://foobar.com:443/")

# user info
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://user:pass@foobar.com")

# regex
(z <- UriPattern$new(regex_pattern = ".+ample\\\\.."))
z$matches("http://sample.org")
z$matches("http://example.com")
z$matches("http://tramples.net")

# add query parameters
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$add_query_params(list(pizza = "cheese", cheese = "cheddar"))
z$pattern

(z <- UriPattern$new(pattern = "http://foobar.com"))
z$pattern
z$add_query_params(list(pizza = "deep dish", cheese = "cheddar"))
z$pattern

# any pattern
(z <- UriPattern$new(regex_pattern = ".+"))
z$regex
z$pattern
z$matches("http://stuff.com")
z$matches("https://stuff.com")
z$matches("https://stuff.com/stff")
z$matches("https://stuff.com/apple?bears=3")
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pattern}}{(character) pattern holder}

\item{\code{regex}}{a logical}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{UriPattern$new()}}
\item \href{#method-matches}{\code{UriPattern$matches()}}
\item \href{#method-add_query_params}{\code{UriPattern$add_query_params()}}
\item \href{#method-to_s}{\code{UriPattern$to_s()}}
\item \href{#method-clone}{\code{UriPattern$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{UriPattern} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$new(pattern = NULL, regex_pattern = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{(character) a uri, as a character string. if scheme
is missing, it is added (we assume http)}

\item{\code{regex_pattern}}{(character) a uri as a regex character string,
see \link[base:regex]{base::regex}. if scheme is missing, it is added (we assume
http)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{UriPattern} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-matches"></a>}}
\if{latex}{\out{\hypertarget{method-matches}{}}}
\subsection{Method \code{matches()}}{
Match a list of headers against that stored
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$matches(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(character) a uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_query_params"></a>}}
\if{latex}{\out{\hypertarget{method-add_query_params}{}}}
\subsection{Method \code{add_query_params()}}{
Add query parameters to the URI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$add_query_params(query_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_params}}{(list|character) list or character}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned, updates uri pattern
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_s"></a>}}
\if{latex}{\out{\hypertarget{method-to_s}{}}}
\subsection{Method \code{to_s()}}{
Print pattern for easy human consumption
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$to_s()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
