% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-static.R
\name{mw_static}
\alias{mw_static}
\title{Middleware function to serve static files}
\usage{
mw_static(root, set_headers = NULL)
}
\arguments{
\item{root}{Root path of the served files. Everything under this
directory is served automatically. Directory lists are not currently
supports.}

\item{set_headers}{Callback function to call before a file is served.}
}
\value{
Handler function.
}
\description{
The content type of the response is set automatically from the
extension of the file. Note that this is a terminal middleware
handler function. If a file is served, then the rest of the handler
functions will not be called. If a file was not found, however,
the rest of the handlers are still called.
}
\examples{
root <- system.file(package = "webfakes", "examples", "static", "public")
app <- new_app()
app$use(mw_static(root = root))
app
}
\seealso{
Other middleware: 
\code{\link{mw_etag}()},
\code{\link{mw_json}()},
\code{\link{mw_log}()},
\code{\link{mw_multipart}()},
\code{\link{mw_raw}()},
\code{\link{mw_text}()},
\code{\link{mw_urlencoded}()}
}
\concept{middleware}
