% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etox.R
\name{get_etoxid}
\alias{get_etoxid}
\title{Get ETOX ID}
\usage{
get_etoxid(
  query,
  from = c("name", "cas", "ec", "gsbl", "rtecs"),
  match = c("all", "best", "first", "ask", "na"),
  verbose = getOption("verbose")
)
}
\arguments{
\item{query}{character; The searchterm}

\item{from}{character; Type of input, can be one of "name" (chemical name),
"cas" (CAS Number), "ec" (European Community number for regulatory purposes),
"gsbl" (Identifier used by \url{https://www.gsbl.de}) and "rtecs" (Identifier used
by the Registry of Toxic Effects of Chemical Substances database).}

\item{match}{character; How should multiple hits be handeled? "all" returns
all matched IDs, "first" only the first match, "best" the best matching (by
name) ID, "ask" is a interactive mode and the user is asked for input, "na"
returns \code{NA} if multiple hits are found.}

\item{verbose}{logical; print message during processing to console?}
}
\value{
a tibble with 3 columns: the query, the match, and the etoxID
}
\description{
Query ETOX: Information System Ecotoxicology and Environmental Quality
Targets \url{https://webetox.uba.de/webETOX/index.do} for their substance ID
}
\note{
Before using this function, please read the disclaimer
\url{https://webetox.uba.de/webETOX/disclaimer.do}.
}
\examples{
\dontrun{
# might fail if API is not available
get_etoxid("Triclosan")
# multiple inputs
comps <- c("Triclosan", "Glyphosate")
get_etoxid(comps)
get_etoxid(comps, match = "all")
get_etoxid("34123-59-6", from = "cas") # Isoproturon
get_etoxid("133483", from = "gsbl") # 3-Butin-1-ol
get_etoxid("203-157-5", from = "ec") # Paracetamol
}
}
\references{
Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
Information from the Web. Journal of Statistical Software, 93(13).
\doi{10.18637/jss.v093.i13}.
}
\seealso{
\code{\link{etox_basic}} for basic information,
\code{\link{etox_targets}} for quality targets and
\code{\link{etox_tests}} for test results.
}
