\name{checkDataAvailability}
\alias{checkDataAvailability}
\title{Check if WeatherUnderground has Data for given station and date}
\usage{
checkDataAvailability(station_id, check_date, station_type = "airportCode")
}
\arguments{
  \item{station_id}{is a valid airport code or a valid
  Weather Station ID}

  \item{check_date}{is a a valid string representing a date
  in the past (string "YYYY-MM-DD")}

  \item{station_type}{is either \code{airportCode} or
  \code{id}}
}
\value{
1 if the station does have weather records for input date,
0 if no records were found
}
\description{
Use this function to check if data is available for station
and date If the station code or the date is invalid,
function will return 0
}
\examples{
\dontrun{
data_okay <- checkDataAvailability("HECA", "2014-01-01")

}
}
\references{
For a list of valid Weather Stations, try this format
\url{http://www.wunderground.com/weatherstation/ListStations.asp?selectedCountry=United+States}
and replace with your country of interest
}

