% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_moran.R
\name{ww_local_moran_i}
\alias{ww_local_moran_i}
\alias{ww_local_moran_i_vec}
\alias{ww_local_moran_pvalue}
\alias{ww_local_moran_pvalue_vec}
\alias{ww_local_moran}
\title{Local Moran's I statistic}
\usage{
ww_local_moran_i(data, ...)

ww_local_moran_i_vec(
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  na_rm = TRUE,
  ...
)

ww_local_moran_pvalue(data, ...)

ww_local_moran_pvalue_vec(
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  na_rm = TRUE,
  ...
)

ww_local_moran(
  data,
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  na_rm = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Additional arguments passed to \code{\link[spdep:localmoran]{spdep::localmoran()}}.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{wt}{A "listw" object, for instance as created with \code{\link[=ww_build_weights]{ww_build_weights()}}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of greater, less or two.sided (default).}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A tibble with columns .metric, .estimator, and .estimate and \code{nrow(data)} rows of values.
For grouped data frames, the number of rows returned will be the same as the number of groups.
For \verb{_vec()} functions, a numeric vector of \code{length(truth)} (or NA).
}
\description{
Calculate the local Moran's I statistic for model residuals.
\code{ww_local_moran_i()} returns the statistic itself, while
\code{ww_local_moran_pvalue()} returns the associated p value.
\code{ww_local_moran()} returns both.
}
\examples{
\dontshow{if (rlang::is_installed("sfdep")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(guerry, package = "sfdep")

guerry_modeled <- guerry
guerry_lm <- lm(crime_pers ~ literacy, guerry_modeled)
guerry_modeled$predictions <- predict(guerry_lm, guerry_modeled)

ww_local_moran_i(guerry_modeled, crime_pers, predictions)
ww_local_moran(guerry_modeled, crime_pers, predictions)
\dontshow{\}) # examplesIf}
}
