% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAmendments.R
\name{getAmendments}
\alias{getAmendments}
\title{Get amendments to a bill}
\usage{
getAmendments(
  biennium,
  billNumber,
  paired = TRUE,
  type = c("df", "list", "xml")
)
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billNumber}{Character or numeric vector containing the bill number(s)
to be retrieved.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getAmendments} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get a list of all proposed amendments (accepted and rejected) on the bill,
including the URL to the amendment text
}
\examples{
## get amendments for a single bill
getAmendments("2007-08", "1001")

## get amendments for a specific set of bills
years <- c("2005-06","2007-08","2007-08")
bills <- c(1447,1219,1001)

getAmendments(years, bills, paired = TRUE, type = "df")
}
