% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seltailor.R
\name{seltailor}
\alias{seltailor}
\title{Interactive view of spectrograms to tailor start and end of selections}
\usage{
seltailor(X = NULL, wl = 512, flim = c(0,22), wn = "hanning", mar = 0.5,
 osci = FALSE, pal = reverse.gray.colors.2, ovlp = 70, auto.next = FALSE, pause = 1,
  comments = TRUE, path = NULL)
}
\arguments{
\item{X}{data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The ouptut of \code{\link{seltailor}} or \code{\link{autodetec}} can 
be used as the input data frame. Other data frames can be used as input, but must have at least the 4 columns mentioned above. Required. Notice that, if an output file ("seltailor_output.csv") is found in the working directory it will be given priority over an input data frame.}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512.}

\item{flim}{A numeric vector of length 2 specifying the frequency limit (in kHz) of 
the spectrogram, as in the function \code{\link[seewave]{spectro}}. 
Default is c(0,22).}

\item{wn}{A character vector of length 1 specifying the window function (by default "hanning"). 
See function \code{\link[seewave]{ftwindow}} for more options.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the 
start and end points of the selections to define spectrogram limits. Default is 0.5.}

\item{osci}{Logical argument. If \code{TRUE} adds a oscillogram whenever the spectrograms are produced 
with higher resolution (see seltime). Default is \code{FALSE}.
The external program must be closed before resuming analysis. Default is \code{NULL}.}

\item{pal}{A color palette function to be used to assign colors in the 
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2. See Details.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{auto.next}{Logical argument to control whether the functions moves automatically to the 
next selection. The time interval before moving to the next selection is controled by the 'pause' argument.}

\item{pause}{Numeric vector of length 1. Controls the duration of the waiting period before 
moving to the next selection (in seconds). Default is 1.}

\item{comments}{Logical argument specifying if 'sel.comment' (when in data frame) should be included 
in the title of the spectrograms. Default is \code{TRUE}.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}
}
\value{
.csv file saved in the working directory with start and end time of 
  selections.
}
\description{
\code{seltailor} produces an interactive spectrographic view (similar to \code{\link{manualoc}}) in 
which the start and end times of acoustic signals listed in a data frame can be adjusted.
}
\details{
This function produces an interactive spectrographic view (similar to \code{\link{manualoc}}) 
in which users can select a new start and end of a vocalization unit (e.g. elements)
 by clicking at the end and then at the start of the signal (in any order). In addition, 2
  "buttons" are provided at the upper right side of the spectrogram that
  allow to stop the analysis ("Stop") or go to the next sound file ("next sel"). When a unit 
  has been selected, the function plots red dotted lines in the start and end of the 
  selection in the spectrogram. The  lines "disappear" when a new selections is made.
  Only the last selection is kept for each selection that is adjusted.
  The function produces a .csv file (seltailor_output.csv) with the same information than the input 
  data frame, except for the new time coordinates, plus a new column (X$tailored) indicating if the selection 
  has been tailored. The file is saved in the working directory  and is updated every time the user
   moves into the next sound file (next sel "button") or stop the process 
 (Stop "button").  If no selection (by clicking on the 'next' buttom) the 
 original time coordinates are kept. When resuming the process (after "stop" and re-running 
 the function in the same working directory), the function will continue working on the
 selections that have not been analyzed.
  
  Windows length (wl) controls the temporal and frequency precision of the spectrogram. 
  A high "wl" value increases the frequency resolution but reduces the temporal resolution, and vice versa. Any
  color palette that comes with the seewave package can be used: temp.colors,
  reverse.gray.colors.1, reverse.gray.colors.2, reverse.heat.colors, reverse.terrain.colors,
  reverse.topo.colors, reverse.cm.colors, heat.colors, terrain.colors, topo.colors,
  cm.colors. Note that, unlike \code{\link{manualoc}}, you cannot zoom in the spectrogram \code{\link{seltailor}}. 
  The zoom can be adjusted by setting the \code{mar} argument.
}
\examples{
\dontrun{
#First create empty folder
setwd(tempdir())

data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "manualoc.df"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

seltailor(X =  manualoc.df, flim = c(1,12), wl = 300, auto.next = FALSE)

# need to use the buttoms to manipulate function

# Read output .csv file
seltailor.df <- read.csv("seltailor_output.csv")
seltailor.df

# check this directory for .csv file after stopping function
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{manualoc}}
}

