% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envs_worldclim.R
\name{envs_worldclim}
\alias{envs_worldclim}
\title{envs_worldclim Obtain WorldClim variables}
\usage{
envs_worldclim(bcRes, bcSel, mapCntr, doBrick = FALSE, logger = NULL)
}
\arguments{
\item{bcRes}{numeric. Resolution of the climatic layers. Currently
available resolutions are 0.5, 2.5 and 10.}

\item{bcSel}{character. Vector with bionames to be selected.}

\item{mapCntr}{numeric. Vector with longitude and latitude for a tile.
Required for bcRes 0.5, for other resolutions world data will be downloaded.}

\item{doBrick}{logical. Converts downloaded rasters to brick for faster
processing.}

\item{logger}{Stores all notification messages to be displayed in the
Log Window of Wallace GUI. Insert the logger reactive list here for
running in shiny, otherwise leave the default NULL.}
}
\value{
A rasterStack or a rasterBrick (if doBrick=TRUE) of downloaded
 worldclim rasters at the requested resolution.
}
\description{
download WorldClim variables. See www.worldclim.com.
}
\details{
This function is called by the module envs to download
  WorldClim variables from www.worldclim.com. The variables to be downloaded
  are selected by the user with bcSel and the resolution with bcRes. It
  returns either a rasterStack or rasterBrick of selected variables with
  appropriate names for further analyses.
}
\examples{
\dontrun{
bcRes <- 10 # (10 arcmin)
envar <- c('bio05', 'bio06', 'bio13', 'bio14')
arcmin10 <- envs_worldclim(bcRes, bcSel = envar)
}

}
\seealso{
\code{\link[raster]{getData}}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>
}
