% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hour.R
\name{hour}
\alias{hour}
\title{Generate a Random Sequence of H:M:S Times}
\usage{
hour(n, x = seq(0, 23.5, by = 0.5), prob = NULL, random = FALSE,
  name = "Hour")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{random}{logical.  If \code{TRUE} the times are randomized, otherwise the
times are sequential.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of H:M:S time elements.
}
\description{
Generate a random vector of H:M:S times.
}
\examples{
hour(20)
hour(20, random=TRUE)
}
\seealso{
\code{\link[chron]{times}}
}
\keyword{hour}
\keyword{time}

