% Generated by roxygen2 (4.0.1): do not edit by hand
\name{Fdr.rlrt}
\alias{Fdr.rlrt}
\title{False discovery rate estimation for massively parallel restricted likelihood
ratio tests}
\usage{
Fdr.rlrt(rlrt.obj, threshold)
}
\arguments{
\item{rlrt.obj}{an RLRT object obtained from \code{\link{rlrt.mp}} or
\code{\link{rlrt4d}}.}

\item{threshold}{threshold at which the null hypothesis is rejected.}
}
\value{
A list with elements \item{MoM}{FDR based on method of moments
estimator of RLRT parameters (Greven et al., 2008).} \item{ML}{FDR based on
maximum likelihood estimation of RLRT parameters, as described in Greven et
al. (2008).}
}
\description{
Given a set of RLRT results and a threshold, this function outputs an
estimate of the FDR (in the empirical Bayes sense of Efron, 2010) when the
given threshold is used to determine which null hypotheses to reject.
}
\examples{
# See example for rlrt.mp
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org}
}
\references{
Efron, B. (2010).  \emph{Large-Scale Inference: Empirical Bayes
Methods for Estimation, Testing, and Prediction}.  New York: Cambridge
University Press.

Greven, S., Crainiceanu, C. M., Kuechenhoff, H., and Peters, A. (2008).
Restricted likelihood ratio testing for zero variance components in linear
mixed models.  \emph{Journal of Computational and Graphical Statistics},
17(4), 870--891.
}
\seealso{
\code{\link{rlrt.mp}}, \code{\link{rlrt4d}}
}

