% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.activity.youtube.R
\name{Create.activity.youtube}
\alias{Create.activity.youtube}
\title{Create youtube activity network}
\usage{
\method{Create}{activity.youtube}(datasource, type, verbose = TRUE, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"youtube"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"activity"}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates an activity network from collected youtube video comment threads. Nodes are top-level
comments, reply comments and videos. Edges are directed between the nodes and represent commenting activity.
}
\examples{
\dontrun{
# create a youtube activity network graph
activityNetwork <- youtubeData \%>\% Create("activity")

# network
# activityNetwork$nodes
# activityNetwork$edges
}

}
