% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_metrics_items_cor}
\alias{effect_metrics_items_cor}
\title{Output correlation coefficients for items}
\usage{
effect_metrics_items_cor(
  data,
  cols,
  cross,
  negative = FALSE,
  method = "pearson",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{Tidyselect item variables to correlate (e.g. starts_with...).}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{method}{The output metrics, TRUE or pearson = Pearson's R, spearman = Spearman's rho.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
A volker table containing correlations.
}
\description{
The correlation is calculated using \code{stats::\link[stats:cor.test]{cor.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_metrics_items_cor(data, starts_with("cg_adoption_adv"), starts_with("use_"))


}
\keyword{internal}
