% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics_items_grouped}
\alias{plot_metrics_items_grouped}
\title{Output averages for multiple variables compared by a grouping variable}
\usage{
plot_metrics_items_grouped(
  data,
  cols,
  cross,
  negative = FALSE,
  limits = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures.}

\item{cols}{Tidyselect item variables (e.g. starts_with...).}

\item{cross}{The column holding groups to compare.}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{limits}{The scale limits. Set NULL to extract limits from the labels.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object.
}
\description{
Output averages for multiple variables compared by a grouping variable
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics_items_grouped(data, starts_with("cg_adoption_"), sd_gender)

}
\keyword{internal}
