% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enbs.R
\name{enbs}
\alias{enbs}
\title{Expected net benefit of sampling}
\usage{
enbs(
  evsi,
  costs_setup,
  costs_pp,
  pop,
  time,
  dis = 0.035,
  smooth = FALSE,
  smooth_df = NULL,
  pcut = 0.05
)
}
\arguments{
\item{evsi}{Data frame giving estimates of the expected value of sample
information, as returned by \code{\link{evsi}}.  This may contain
multiple estimates, one for each sample size and willingness to pay.}

\item{costs_setup}{Setup costs of the study.  This can either be a constant,
or a vector of two elements giving a 95\% credible interval (with mean
defined by the midpoint), or a vector of three elements assumed to define
the mean and 95\% credible interval.}

\item{costs_pp}{Per-participant costs of the study, supplied in the same
format as \code{cost_setup}.}

\item{pop}{Size of the population who would be affected by the decision.}

\item{time}{Time horizon over which discounting will be applied.}

\item{dis}{Discount rate used when converting per-person to population EVSI.}

\item{smooth}{If \code{TRUE}, then the maximum ENBS is determined after
fitting a nonparametric regression to the data frame \code{x}, which
estimates and smooths the ENBS for every integer sample size in the range
of \code{x$n}.  The regression is done using the default settings of
\code{\link[mgcv]{gam}} from the \pkg{mgcv} package.

If this is \code{FALSE}, then no smoothing or interpolation is done, and
the maximum is determined by searching over the values supplied in
\code{x}.}

\item{smooth_df}{Basis dimension for the smooth regression. Passed as the
\code{k} argument to the \code{s()} term in \code{\link[mgcv]{gam}}.   Defaults to
6, or the number of unique sample sizes minus 1 if this is lower.  Set
to a higher number if you think the smoother does not capture the
relation of ENBS to sample size accurately enough.}

\item{pcut}{Cut-off probability which defines a "near-optimal" sample size.
The minimum and maximum sample size for which the ENBS is within
\code{pcut} (by default 5\%) of its maximum value will be determined.}
}
\value{
Data frame with components \code{enbs} giving the ENBS, and
\code{sd} giving the corresponding standard deviation.  The rows of the
data frame correspond to the rows of \code{evsi}, and any \code{n} and
\code{k} are inherited from \code{evsi}.  Additional columns include:

\code{pce}: the probability that the study is cost-effective, i.e. that
the ENBS is positive, obtained from a normal distribution defined by the
estimate and standard deviation.

\code{enbsmax}: The maximum ENBS for each willingness-to-pay \code{k}.

\code{nmax}: The sample size \code{n} at which this maximum is achieved.

A second data frame is returned as the \code{"enbsmax"} attribute.
This has one row per willingness-to-pay (\code{k}), giving the optimal
ENBS (\code{enbsmax}) the optimal sample size (\code{nmax}) and an interval
estimate for the optimal sample size (\code{nlower} to \code{nupper}).

If \code{pop}, \code{time} or \code{dis} were supplied as vectors
of more than one element, then additional columns will be returned
in these data frames to identify the population, time or discount
rate for each ENBS calculation.  An index \code{ind} is also returned
to identify the unique combination that each row refers to.
}
\description{
Calculates the expected net benefit of sampling for a typical study to inform
a health economic evaluation, given estimates of the per-person expected
value of sample information, decision population size and study setup and
per-participant costs.   The optimal sample size for each willingness-to-pay,
population size and time horizon is also determined.
}
\details{
\code{pop},\code{time} and \code{dis} may be supplied as vectors
of different lengths.  In that case, the ENBS is calculated for all
possible combinations of the values in these vectors.
}
\references{
Value of Information for Healthcare Decision Making
(CRC Press, eds. Heath, Kunst and Jackson: forthcoming)
}
