% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eocusum_sim.R
\name{eocusum_adoc_sim}
\alias{eocusum_adoc_sim}
\title{Compute steady-state ARLs of EO-CUSUM control charts using simulation}
\usage{
eocusum_adoc_sim(r, k, h, df, coeff, coeff2, QS = 1, side = "low",
  type = "cond", m = 50)
}
\arguments{
\item{r}{Integer. Number of of simulation runs.}

\item{k}{Double. Reference value of the CUSUM control chart. Either \code{0} or a positive
value. Can be determined with function \code{\link{optimal_k}}.}

\item{h}{Double. Decision interval (alarm limit, threshold) of the CUSUM control chart.}

\item{df}{Data Frame. First column Parsonnet Score and second column outcome of each operation.}

\item{coeff}{Numeric Vector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model.}

\item{coeff2}{Numeric Vector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model of a resampled dataset.}

\item{QS}{Double. Defines the performance of a surgeon with the odds ratio ratio of death
\code{Q}.}

\item{side}{Character. Default is \code{"low"} to calculate ARL for the upper arm of the V-mask.
If side = \code{"up"}, calculate the lower arm of the V-mask.}

\item{type}{Character. Default argument is \code{"cond"} for computation of conditional
steady-state. Other option is the cyclical steady-state \code{"cycl"}.}

\item{m}{Integer. Simulated in-control observations.}
}
\value{
Returns a single value which is the Run Length.
}
\description{
Compute steady-state ARLs of EO-CUSUM control charts using simulation.
}
\examples{
\donttest{

# This function is deprecated. See eocusum_ad_sim() instead.

 }
}
\author{
Philipp Wittenberg
}
