% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymise.R
\name{jitter_metrics}
\alias{jitter_metrics}
\title{Jitter metrics in a data frame}
\usage{
jitter_metrics(data, cols = NULL, ...)
}
\arguments{
\item{data}{Data frame containing a query.}

\item{cols}{Character vector containing the metrics to jitter. When set to
\code{NULL} (default), all numeric columns in the data frame are jittered.}

\item{...}{Additional arguments to pass to \code{jitter()}.}
}
\value{
data frame where numeric columns specified by \code{cols} are jittered using the
function \code{jitter()}.
}
\description{
Convenience wrapper around \code{jitter()} to add a layer of
anonymity to a query. This can be used in combination with \code{anonymise()} to
produce a demo dataset from real data.
}
\examples{
jittered <- jitter_metrics(pq_data, cols = "Collaboration_hours")

# compare jittered vs original results of top rows
head(
  data.frame(
    original = pq_data$Collaboration_hours,
    jittered = jittered$Collaboration_hours
  )
)

}
\seealso{
anonymise
}
