% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\title{Option Parameter Visualization}
\usage{
visualize(type = "call", parameter = "premium", s = 100, si = 100,
  x1 = 90, x2 = 95, x3 = 105, x4 = 110, v1 = 0.2, v2 = v1,
  v3 = v1, v4 = v1, ti = 45/365, r = 0.02, d = 0, ls = 1,
  low = 75, high = 125, e1 = (0), e2 = (5/365), e3 = (10/365),
  e4 = (15/365), e5 = (20/365), e6 = (25/365), e7 = (30/365),
  e8 = (35/365), e9 = (40/365), e10 = (45/365), c1 = 1, c2 = 1,
  c3 = 1, c4 = 1)
}
\arguments{
\item{type}{Character String: "call" or "put"}

\item{parameter}{Character String: "premium", "delta", "gamma", "vega", "theta", "rho"}

\item{s}{Underlying Asset Price}

\item{si}{Initial Price of the underlying asset}

\item{x1}{Option 1 Strike}

\item{x2}{Option 2 Strike}

\item{x3}{Option 3 Strike}

\item{x4}{Option 4 Strike}

\item{v1}{Option 1 Volatility}

\item{v2}{Option 2 Volatility}

\item{v3}{Option 3 Volatility}

\item{v4}{Option 4 Volatility}

\item{ti}{Initial time to maturity in years}

\item{r}{Annualized continuously compounded risk-free rate}

\item{d}{Annualized continuously compounded dividend yield}

\item{ls}{Numerical either 1 or -1}

\item{low}{Lower Limit for the price range}

\item{high}{Upper Limit for the price range}

\item{e1}{Expiration in years, set to 0}

\item{e2}{Expiration in years, set to 5/365}

\item{e3}{Expiration in years, set to 10/365}

\item{e4}{Expiration in years, set to 15/365}

\item{e5}{Expiration in years, set to 20/365}

\item{e6}{Expiration in years, set to 25/365}

\item{e7}{Expiration in years, set to 30/365}

\item{e8}{Expiration in years, set to 35/365}

\item{e9}{Expiration in years, set to 40/365}

\item{e10}{Expiration in years, set to 45/365}

\item{c1}{Option 1, Number of Contracts}

\item{c2}{Option 2, Number of Contracts}

\item{c3}{Option 3, Number of Contracts}

\item{c4}{Option 4, Number of Contracts}
}
\value{
Plots a 3d Graph in the Viewer tab
}
\description{
Creates a 3D Plot of an Option Parameter plotted over time
}
\examples{
visualize(type = "put", parameter = "delta", s = 100, si = 100,
    x1 = 90, x2 = 95, x3 = 105, x4 = 110, v1 = 0.20,
    ti = 45/365, r = 0.02, d = 0, ls = 1,
    low = 75, high = 125, e1 =(45/365), e2 = (30/365),
    e3 = (15/365), e4 = (1/365), c1 = 1, c2 = 1, c3 = 1, c4 = 1)


}
