% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_mse}
\alias{metric_mse}
\alias{metric_rmse}
\alias{metric_sse}
\alias{metric_mae}
\alias{metric_rsquared}
\alias{metric_accuracy}
\alias{metric_error}
\alias{metric_auc}
\alias{metric_logLoss}
\alias{metric_mauc}
\title{Model metrics}
\usage{
metric_mse(actual, predicted, na.rm = FALSE)

metric_rmse(actual, predicted, na.rm = FALSE)

metric_sse(actual, predicted, na.rm = FALSE)

metric_mae(actual, predicted, na.rm = FALSE)

metric_rsquared(actual, predicted, na.rm = FALSE)

metric_accuracy(actual, predicted, na.rm = FALSE)

metric_error(actual, predicted, na.rm = FALSE)

metric_auc(actual, predicted)

metric_logLoss(actual, predicted)

metric_mauc(actual, predicted)
}
\arguments{
\item{actual}{Vector of actual target values.}

\item{predicted}{Vector of predicted target values.}

\item{na.rm}{Logical indicating whether or not \code{NA} values should be
stripped before the computation proceeds.}
}
\description{
Common model/evaluation metrics for machine learning.
}
\note{
The \code{metric_auc} and \code{metric_logLoss} functions are based on
code from the \href{https://cran.r-project.org/package=Metrics}{Metrics}
package.
}
\examples{
x <- rnorm(10)
y <- rnorm(10)
metric_mse(x, y)
metric_rsquared(x, y)
}
