% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{run_sl}
\alias{run_sl}
\title{Run a Super Learner for the provided subset of features}
\usage{
run_sl(
  Y = NULL,
  X = NULL,
  V = 5,
  SL.library = "SL.glm",
  univariate_SL.library = "SL.glm",
  s = 1,
  cv_folds = NULL,
  sample_splitting = TRUE,
  ss_folds = NULL,
  verbose = FALSE,
  progress_bar = NULL,
  indx = 1,
  weights = rep(1, nrow(X)),
  cross_fitted_se = TRUE,
  ...
)
}
\arguments{
\item{Y}{the outcome}

\item{X}{the covariates}

\item{V}{the number of folds}

\item{SL.library}{the library of candidate learners}

\item{univariate_SL.library}{the library of candidate learners for
single-covariate regressions}

\item{s}{the subset of interest}

\item{cv_folds}{the CV folds}

\item{sample_splitting}{logical; should we use sample-splitting for
predictiveness estimation?}

\item{ss_folds}{the sample-splitting folds; only used if
\code{sample_splitting = TRUE}}

\item{verbose}{should we print progress? defaults to FALSE}

\item{progress_bar}{the progress bar to print to (only if verbose = TRUE)}

\item{indx}{the index to pass to progress bar (only if verbose = TRUE)}

\item{weights}{weights to pass to estimation procedure}

\item{cross_fitted_se}{if \code{TRUE}, uses a cross-fitted estimator of
the standard error; otherwise, uses the entire dataset}

\item{...}{other arguments to Super Learner}
}
\value{
a list of length V, with the results of predicting on the hold-out data for each v in 1 through V
}
\description{
Run a Super Learner for the provided subset of features
}
