% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cum.sum.R
\name{cum.view}
\alias{cum.view}
\title{Compute cumulated viewsheds in a 3D TLS scene from multiple location}
\usage{
cum.view(data, locations, param, vox_res)
}
\arguments{
\item{data}{a data.frame containing the xyz coordinates of a TLS point cloud}

\item{locations}{a data.frame with each row containing the xyz coordinates of one point representing the animal location at a single point in time.}

\item{param}{a data.frame containing the directions that will be used to explore the point cloud}

\item{vox_res}{the voxel resolution}
}
\value{
a data frame containing the x,y,z coordinates of a voxel cloud plus the number of locations from which each voxel could be seen
}
\description{
Compute cumulated viewsheds in a 3D TLS scene from multiple location
}
\examples{
\donttest{
library(viewshed3d)
data(TLSrecons)
data(param_2)

locations=data.frame(c(12,12),c(58,60),c(0,0))

cum=cum.view(TLSrecons,param = param_2,location=locations,vox_res = 0.2)

library(viridis)
library(rgl)
col=cividis(max(cum[,4])+1)

plot3d(cum,col=col[cum[,4]+1],add=TRUE,size=8)
points3d(locations,col="red",size=5)
}
}
