% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennplot.R
\name{vennplot}
\alias{vennplot}
\title{Draw Venn diagram in 2D or 3D}
\usage{
vennplot(combinations = NULL, fit = 0.5, GRAM = T, main = NULL,
  arbitrary = NULL, mu = 2, NAME = NULL, ALPHA = 10^(-5),
  alpha.col = 0.3, disjoint = F, ThreeD = FALSE, delta = 0.01,
  mar = rep(1, 4), priority = 2, weight = rep(1, length(priority)))
}
\arguments{
\item{combinations}{Named numeric vector or data.frame where each row is a logical vector indicating set membership.  See Details.}

\item{fit}{Scaling of semi-diameters; a scalar between 0.5 and 1.}

\item{GRAM}{If \code{TRUE}, use the centralized GRAM matrix as the initial location.  Otherwise use the center of an arbitrary circle.}

\item{main}{Title of 2D plot.}

\item{arbitrary}{When \code{GRAM = FALSE}, an integer designating which circle to use for inital location, or \code{NULL} to use a random circle.  Argument is ignored when \code{GRAM = TRUE}.}

\item{mu}{Generates defaults for unspecificed two-way intersections.  See Details.}

\item{NAME}{The name of each circle. See Examples.}

\item{ALPHA}{Size of steepest descent.}

\item{alpha.col}{Color darkness.}

\item{disjoint}{If \code{TRUE} plots only the disjoint part of overlapping circles.}

\item{ThreeD}{Draw Venn diagram in 3D. See Examples.}

\item{delta}{Closeness betwen connected components.}

\item{mar}{Plot margins.}

\item{priority}{Scalar or vector specifying the fitting priority for intersections.  See Examples.}

\item{weight}{Priority weights.  Must the the same length as \code{priority}.  See Examples.}
}
\value{
An object of the class \code{vennplot} with following components:
\describe{
  \item{center}{centers of the circles (columns are (\code{x}, \code{y}) or (\code{x}, \code{y}, \code{z}) coordinates).}
  \item{semidiameters}{semi-diameters of the circles.}
  \item{LOSS}{total loss of \code{vennplot}.}
  \item{weighted.least.square}{Given specific priorities and weights, the weighted least square between input and lay-out.}
}
}
\description{
Draw Venn diagram in 2D or 3D
}
\details{
The names of data sets (circles) supplied to \code{combination} must be single letters, e.g., \code{combination = c(A=1, B=2, AB=0.5)}.  Here \code{A} means the whole data-set, so does \code{B}, which means \code{AB} can be no larger than \code{min(A,B)}.

If a few two way intersections are unspecified, \code{mu} gives one way to generate them. For example, Suppose input combinations are \code{c(a=1,b=2,c=1,abc = 0.2)}.  Then default values for the two-way interserctions are  \code{ab = mu^(3-2)*abc = 0.2mu^(3-2)}, and \code{bc = mu^(3-2)*abc = 0.2mu^(3-2), ac = mu^(3-2)*abc = 0.2mu^(3-2)}.
}

\author{Zehao Xu <z267xu@uwaterloo.ca>, R. Wayne Oldford, Martin Lysy}

\examples{
# arbitray sets
combinations = c(A=1.8, B=0.9,C=1.3, D = 1.3,E = 1.6, AC=0.3,
                 AD= 0.3,BE = 0.3, AE = 0.4, f = 0.7,g =0.8,
                 h = 0.5, gf = 0.2, Bh = 0.1,i = 1,j = 0.4,
                 k=0.7,l = 1.4,kl = 0.2,m = 0.5,lm = 0.2,
                 o = 0.8,p = 0.9, op = 0.3)
ve = vennplot(combinations)

# named sets
# combinations = c(A=1, B=1,C=1, ABC = 0.1)
# ve = vennplot(combinations,NAME = c("Loon","Goose","Duck"))

# effect of parameter mu
# combinations = c(A=1, B=1, C=1, D=1, E=1, ABCDE = 0.1)
# par(mfrow = c(1,3))
# ve = vennplot(combinations)
# ve = vennplot(combinations,mu=2)
# ve = vennplot(combinations,mu=1.2)

# 3D Venn plot
combinations = c(A=803, B=304,C=1015, D = 1100,E = 1005,f = 967,H=3020,
                 CD = 1000,BC = 248,ABC = 185,ADE = 327,CDfH = 846,
                 I=800, J=760,K=1000, L = 1100,M = 900, IK=333,
                 JM = 251,IL= 289, KM = 412,JL = 213)
timestart <- Sys.time()
ve = vennplot(combinations, disjoint = TRUE,ThreeD = TRUE)
timeend <- Sys.time()
runningtime <- timeend-timestart
print(runningtime)

# effect of parameters priority and weight
# combinations = c(A = 79,B=29,C=58,AB = 25,AC = 44, BC=18,ABC = 1)
# par(mfrow = c(2,2))
# vennplot(combinations, priority = 2)
# vennplot(combinations, priority = 3)
# vennplot(combinations, priority = c(2,3), weight = c(30,1000))
# vennplot(combinations, priority = c(2,3), weight = c(30,10))

# binary data
# combinations = sharks[,c(1,3:5,8)]
# vennplot(combinations = combinations)
}
