% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_cast.R
\name{VeloxRaster_as.RasterLayer}
\alias{VeloxRaster_as.RasterLayer}
\title{Cast a VeloxRaster band as a RasterLayer object}
\arguments{
\item{band}{Integer indicating the VeloxRaster band to be transformed.}

\item{assign_data_type}{Boolean indicating whether the dataType attribute of the returned RasterLayer should be set.
If TRUE, the dataType attribute is set to the smallest possible data type.}
}
\value{
A RasterLayer object.
}
\description{
\code{as.RasterLayer} creates a RasterLayer object from a VeloxRaster band.
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Cast to RasterLayer
library(raster)
rl <- vx$as.RasterLayer(band=1)

}

