% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_hdv.R
\name{age_hdv}
\alias{age_hdv}
\title{Returns amount of vehicles at each age}
\usage{
age_hdv(x, name = "age", a = 0.2, b = 17, agemin = 1,
  agemax = 50, k = 1, bystreet = F, net, verbose = FALSE, namerows)
}
\arguments{
\item{x}{Numeric; numerical vector of vehicles with length equal to lines features of road network}

\item{name}{Character; of vehicle assigned to columns of dataframe}

\item{a}{Numeric; parameter of survival equation}

\item{b}{Numeric; parameter of survival equation}

\item{agemin}{Integer; age of newest vehicles for that category}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{k}{Numeric; multiplication factor. If its length is > 1, it must match the length of x}

\item{bystreet}{Logical; when TRUE it is expecting that 'a' and 'b' are numeric vectors with length equal to x}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{verbose}{Logical;  message with average age and total numer of vehicles}

\item{namerows}{Any vector to be change row.names. For instance, name of
regions or streets.}
}
\value{
dataframe of age distrubution of vehicles at each street
}
\description{
\code{\link{age_hdv}} returns amount of vehicles at each age
}
\examples{
{
data(net)
LT_B5 <- age_hdv(x = net$hdv,name = "LT_B5")
plot(LT_B5)
LT_B5 <- age_hdv(x = net$hdv, name = "LT_B5", net = net)
plot(LT_B5)
}
}
