% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_grid.R
\name{emis_grid}
\alias{emis_grid}
\title{Allocate emissions into a grid}
\usage{
emis_grid(spobj, g, sr, type = "lines")
}
\arguments{
\item{spobj}{A spatial dataframe of class "sp" or "sf". When class is "sp"
it is transformed to "sf".}

\item{g}{A grid with class "SpatialPolygonsDataFrame" or "sf".}

\item{sr}{Spatial reference e.g: 31983. It is required if spobj and g are
not projected. Please, see http://spatialreference.org/.}

\item{type}{type of geometry: "lines" or "points".}
}
\description{
\code{emis_grid} allocates emissions proportionally to each grid
 cell. The process is performed by intersection between geometries and the grid.
It means that requires "sr" according with your location for the projection.
It is assumed that spobj is a spatial*DataFrame or an "sf" with the pollutants
in data. This function return an object class "sf".
}
\note{
When spobj is a 'Spatial' object (class of sp), they are converted
 into 'sf'. Also, The aggregation of data ise done with data.table functions.
}
\examples{
\dontrun{
data(net)
data(pc_profile)
data(fe2015)
data(fkm)
PC_G <- c(33491,22340,24818,31808,46458,28574,24856,28972,37818,49050,87923,
          133833,138441,142682,171029,151048,115228,98664,126444,101027,
          84771,55864,36306,21079,20138,17439, 7854,2215,656,1262,476,512,
          1181, 4991, 3711, 5653, 7039, 5839, 4257,3824, 3068)
veh <- data.frame(PC_G = PC_G)
pc1 <- my_age(x = net$ldv, y = PC_G, name = "PC")
pcw <- temp_fact(net$ldv+net$hdv, pc_profile)
speed <- netspeed(pcw, net$ps, net$ffs, net$capacity, net$lkm, alpha = 1)
pckm <- fkm[[1]](1:24); pckma <- cumsum(pckm)
cod1 <- emis_det(po = "CO", cc = 1000, eu = "III", km = pckma[1:11])
cod2 <- emis_det(po = "CO", cc = 1000, eu = "I", km = pckma[12:24])
#vehicles newer than pre-euro
co1 <- fe2015[fe2015$Pollutant=="CO", ] #24 obs!!!
cod <- c(co1$PC_G[1:24]*c(cod1,cod2),co1$PC_G[25:nrow(co1)])
lef <- ef_ldv_scaled(co1, cod, v = "PC", t = "4S", cc = "<=1400",
                     f = "G",p = "CO", eu=co1$Euro_LDV)
E_CO <- emis(veh = pc1,lkm = net$lkm, ef = lef, speed = speed, agemax = 41,
             profile = pc_profile, hour = 24, day = 7, array = TRUE)
# arguments required: arra, pollutant ad by
E_CO_STREETS <- emis_post(arra = E_CO, pollutant = "CO", by = "streets_wide")
net@data <- cbind(net@data, E_CO_STREETS)
head(net@data)
g <- make_grid(net, 1/102.47/2, 1/102.47/2) #500m in degrees

net@data <- net@data[,- c(1:9)]
names(net)
E_CO_g <- emis_grid(spobj = net, g = g, sr= 31983)
head(E_CO_g) #class sf
E_CO_g$V138 <- as.numeric(E_CO_g$V138)
E_CO_g <- as(E_CO_g, "Spatial")
spplot(E_CO_g, "V138", scales=list(draw=T),cuts=8,
colorkey = list(space = "bottom", height = 1),
col.regions = rev(bpy.colors(9)),
sp.layout = list("sp.lines", net, pch = 16, cex = 2, col = "black"))
}
}
