% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cassette_class.R
\docType{data}
\name{Cassette}
\alias{Cassette}
\title{Cassette handler}
\arguments{
\item{name}{The name of the cassette. vcr will sanitize this to ensure it
is a valid file name.}

\item{record}{The record mode. Default: "once". In the future we'll support
"once", "all", "none", "new_episodes". See \link{recording} for more information}

\item{serialize_with}{(character) Which serializer to use.
Valid values are "yaml" (default), the only one supported for now.}

\item{persist_with}{(character) Which cassette persister to
use. Default: "file_system". You can also register and use a
custom persister.}

\item{match_requests_on}{List of request matchers
to use to determine what recorded HTTP interaction to replay. Defaults to
\code{["method", "uri"]}. The built-in matchers are "method", "uri",
"headers" and "body" ("host" and "path" not supported yet, but should
be in a future version)}

\item{update_content_length_header}{(logical) Whether or
not to overwrite the \code{Content-Length} header of the responses to
match the length of the response body. Default: \code{FALSE}}

\item{allow_playback_repeats}{(logical) Whether or not to
allow a single HTTP interaction to be played back multiple times.
Default: \code{FALSE}.}

\item{preserve_exact_body_bytes}{(logical) Whether or not
to base64 encode the bytes of the requests and responses for
this cassette when serializing it. See also \code{preserve_exact_body_bytes}
in \code{\link[=vcr_configure]{vcr_configure()}}. Default: \code{FALSE}}
}
\value{
an object of class \code{Cassette}
}
\description{
Cassette handler
}
\details{
\strong{Methods}
\describe{
\item{\code{eject()}}{
Coming soon.
}
\item{\code{file()}}{
Get path to the man file for the cassette.
}
\item{\code{recording()}}{
Find out whether recording is happening or not.
}
\item{\code{originally_recorded_at()}}{
Time interaction was originally recorded at.
}
\item{\code{serializable_hash()}}{
A hash with stuff.
}
\item{\code{should_remove_matching_existing_interactions()}}{
Set record mode to "all".
}
\item{\code{storage_key()}}{
Generate file name = cassette name plus file extension.
}
\item{\code{make_dir()}}{
Make cassette directory.
}
\item{\code{raw_string()}}{
Get raw string of the cassette (cached interaction).
}
\item{\code{deserialized_hash()}}{
Get a deserialized hash.
}
\item{\code{make_args()}}{
Initialize default args.
}
\item{\code{write_metadata()}}{
Write metadata to disk.
}
\item{\code{previously_recorded_interactions()}}{
Coming soon.
}
\item{\code{serialize_to_crul}}{
Serialize interaction on disk/cassette to a \code{crul} response
}
}
}
\examples{
library(vcr)
vcr_configure(dir = tempdir())

res <- Cassette$new(name = "bob")
res$file()
res$originally_recorded_at()
res$recording()
res$serializable_hash()
res$eject()
res$should_remove_matching_existing_interactions()
res$storage_key()
res$match_requests_on

# record all requests
res <- Cassette$new("foobar", record = "all")
res$eject()

# cleanup
unlink(file.path(tempdir(), c("bob.yml", "foobar.yml")))
}
\seealso{
\code{\link[=vcr_configure]{vcr_configure()}}, \code{\link[=use_cassette]{use_cassette()}}, \code{\link[=insert_cassette]{insert_cassette()}}
}
\keyword{internal}
