##################################################################
## spacings

spacing_equal <- function(sp = unit(0.5, "lines")) {
  if (!is.unit(sp)) sp <- unit(sp, "lines")
  function(d, condvars = NULL) lapply(d, function(x) unit.rep(sp, x - 1))
}
class(spacing_equal) <- "panel_generator"

spacing_dimequal <- function(sp) {
  if (!is.unit(sp)) sp <- unit(sp, "lines")
  function(d, condvars = NULL)
    lapply(seq(along = d), function(i) unit.rep(sp[i], d[[i]] - 1))
}
class(spacing_dimequal) <- "panel_generator"

spacing_increase <- function(start = unit(0.3, "lines"), rate = 1.5) {
  if (!is.unit(start)) start <- unit(start, "lines")
  function(d, condvars = NULL) {
    sp <- start * rev(cumprod(c(1, rep.int(rate, length(d) - 1))))
    lapply(seq(along = d), function(i) unit.rep(sp[i], d[[i]] - 1))
  }
}
class(spacing_increase) <- "panel_generator"

spacing_doubledecker <- function(start = unit(0.3, "lines"), rate = 1.8)
  function(d, condvars) {
    if (length(d) < 3) {
      start[2] <- 0
      spacing_dimequal(start)(d, condvars)
    } else
      spacing_conditional(sp = 0, start = start, rate = rate)(d, condvars)
  }
class(spacing_doubledecker) <- "panel_generator"

spacing_conditional <- function(sp = unit(0.5, "lines"),
                                start = unit(2, "lines"), rate = 1.8) {
  condfun <- spacing_increase(start, rate)
  equalfun <- spacing_equal(sp)
  equalfun2 <- spacing_equal(start)
  function(d, condvars) {
    if (length(d) < 3)
      return(spacing_equal(sp)(d, condvars))
    condvars <- seq(condvars)
    ret <- vector("list", length(d))
    ret[condvars] <- if (length(condvars) < 3)
      equalfun2(d[condvars])
    else
      condfun(d[condvars])
    ret[-condvars] <- equalfun(d[-condvars])
    ret
  }
}
class(spacing_conditional) <- "panel_generator"
