"serial" <-
function(x, lags.pt = 16, lags.bg = 5){
  if(!(class(x)=="varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'var()'.\n")
  }
  obj.name <- deparse(substitute(x))
  K <- x$K
  obs <- x$obs
  resids <- x$resid
  lags.pt <- abs(as.integer(lags.pt))
  lags.bg <- abs(as.integer(lags.bg))
  ptm.resids <- .pt.multi(x, K = K, obs = obs, lags.pt = lags.pt, obj.name = obj.name, resids = resids)
  bg.resids <- .bgserial(x, K = K, obs = obs, lags.bg = lags.bg, obj.name = obj.name, resids = resids)
  if(is.null(x$restrictions)){
    result <- list(resid = resids, pt.mul = ptm.resids, LMh = bg.resids[1], LMFh = bg.resids[2])
  } else {
    result <- list(resid = x$resid, pt.mul = ptm.resids, LMh = bg.resids[1])
  }
  class(result) <- "varcheck"
  return(result)
}
