% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.muse.sample.R
\name{run.muse.sample}
\alias{run.muse.sample}
\title{Run MuSE for a sample}
\usage{
run.muse.sample(tumour.bam, sample.id, paired, normal.bam = NULL,
  output.directory = NULL, output.filename = NULL,
  code.directory = NULL, log.directory = NULL, config.file = NULL,
  job.dependencies = NULL, quiet = FALSE, job.name = NULL,
  verify.options = !quiet, job.group = NULL)
}
\arguments{
\item{tumour.bam}{Path to tumour sample BAM file.}

\item{sample.id}{Sample ID for labelling}

\item{paired}{Logical indicating whether to do variant calling with a matched normal.}

\item{normal.bam}{Path to normal BAM file if \code{paired = TRUE}}

\item{output.directory}{Path to output directory}

\item{output.filename}{Name of resulting VCF file (defaults to SAMPLE_ID.vcf)}

\item{code.directory}{Path to directory where code should be stored}

\item{log.directory}{Path to directory where log files should be stored}

\item{config.file}{Path to config file}

\item{job.dependencies}{Vector with names of job dependencies}

\item{quiet}{Logical indicating whether to print command to screen rather than submit it to the system. Defaults to false, useful for debugging.}

\item{job.name}{Name of job to be submitted}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}

\item{job.group}{Group job should belong to}
}
\description{
Run MuSE for a sample
}
