% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpers.R
\name{res_gamma}
\alias{res_gamma}
\title{Estimates the parameters of a Gamma distribution from SDs}
\usage{
res_gamma(x, ID)
}
\arguments{
\item{x}{A data vector to operate on}

\item{ID}{an ID variable of the same length as \code{x}}
}
\value{
a list of the shape (alpha) and rate (beta) parameters
  and the mean and variance
}
\description{
This function calcualtes the parameters of a Gamma distribution
from the residuals from an individuals' own mean.
That is, the distribution of (standard) deviations from individuals'
own mean are calculated and then an estimate of the parameters of a
Gamma distribution are calculated.
}
\examples{
set.seed(1234)
y <- rgamma(100, 3, 2)
x <- rnorm(100 * 10, mean = 0, sd = rep(y, each = 10))
ID <- rep(1:100, each = 10)
res_gamma(x, ID)
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}

