% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanProteinStructures.R
\name{RemoveHydrogenAtoms}
\alias{RemoveHydrogenAtoms}
\title{Remove Hydrogen and Deuterium Atoms}
\usage{
RemoveHydrogenAtoms(atoms.chains.oi)
}
\arguments{
\item{atoms.chains.oi}{The data.frame containing the PDB file information;
aka the PDB structure}
}
\value{
data.frame of the PDB structure \emph{without} hydrogen or deuterium
atoms
}
\description{
Removes hydrogen atoms from a RCSB/PDB structure.
}
\details{
Removes hydrogen and deuterium atoms from a PDB formatted
\code{\link[base:data.frame]{base::data.frame()}} with PDB formatted information.
}
\examples{
  \donttest{
  PDB.5rxn.noHydrogens <- RemoveHydrogenAtoms(PDB.5rxn$atom)
  }

}
\seealso{
Other "Clean Protein Structure": \code{\link{CleanProteinStructures}},
  \code{\link{RemoveModeledAtoms}},
  \code{\link{RemoveOoR.b}}, \code{\link{RemoveOoR.o}},
  \code{\link{RetainWatersWithinX}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Clean Protein Structure"}
