% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values.R
\name{values,tbl_validation-method}
\alias{values,tbl_validation-method}
\title{Retrieve the result of a validation/confrontation}
\usage{
\S4method{values}{tbl_validation}(
  x,
  simplify = type == "matrix",
  type = c("tbl", "matrix", "list", "data.frame"),
  ...
)
}
\arguments{
\item{x}{\code{\link[=tbl_validation]{tbl_validation()}}, result of a \code{confront()} of \code{tbl} with a rule set.}

\item{simplify}{only use when \code{type} = "list" see \code{validate::values}}

\item{type}{whether to return a list/matrix or to return a query on the database.}

\item{...}{not used}
}
\value{
depending on \code{type} the result is different, see details
}
\description{
Retrieve the result of a validation/confrontation.
}
\details{
Since the validation is done on a database, there are multiple options
for storing the result of the validation. The results show per record whether
they are valid according to the validation rules supplied.
\itemize{
\item Use \code{compute} (see \code{\link[=confront.tbl_sql]{confront.tbl_sql()}}) to store the result in the database
\item Use \code{sparse} to only calculate "fails" and "missings"
}

Default type "tbl" is that everything is "lazy", so the query and/or storage has to
be done explicitly by the user.
The other types execute the query and retrieve the result into R. When this
creates memory problems, the \code{tbl} option is to be preferred.

Results for \code{type}:
\itemize{
\item \code{tbl}: a \link[dbplyr:tbl.src_dbi]{dbplyr::tbl_dbi} object, pointing to the database
\item \code{matrix}: a R matrix, similar to \code{\link[validate:values]{validate::values()}}.
\item \code{list}: a R list, similar to \code{\link[validate:values]{validate::values()}}.
\item \code{data.frame}: the result of \code{tbl} stored in a \code{data.frame}.
}
}
\examples{
# create a table in a database
income <- data.frame(id = letters[1:2], age=c(12,35), salary = c(1000,NA))
con <- dbplyr::src_memdb()
tbl_income <- dplyr::copy_to(con, income, overwrite=TRUE)
print(tbl_income)

# Let's define a rule set and confront the table with it:
rules <- validator( is_adult   = age >= 18
                  , has_income = salary > 0
                  , mean_age   = mean(age,na.rm=TRUE) > 20
                  )

# and confront!
cf <- confront(tbl_income, rules)
print(cf)
summary(cf)

# Values (i.e. validations on the table) can be retrieved like in `validate` 
# with`type="matrix"` (simplify = TRUE)
values(cf, type = "matrix")

# But often this seems more handy:
values(cf, type = "tbl")

# We can see the sql code by using `show_query`:
show_query(cf)

# identical
show_query(values(cf, type = "tbl"))

# adding a key often is handy in a database
cf <- confront(tbl_income, rules, key = "id")
print(cf)
values(cf, type="tbl")

# sparse results in db
cf_sparse <- confront(tbl_income, rules, sparse=TRUE)
values(cf_sparse, type="tbl")
}
\seealso{
Other validation: 
\code{\link{confront.tbl_sql}()},
\code{\link{tbl_validation-class}}
}
\concept{validation}
