% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{as.data.frame,cellComparison-method}
\alias{as.data.frame,cellComparison-method}
\title{Translate cellComparison objects to data frame}
\usage{
\S4method{as.data.frame}{cellComparison}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{Object to coerce}

\item{row.names}{ignored}

\item{optional}{ignored}

\item{...}{arguments passed to other methods}
}
\value{
A data frame with the following columns.
\itemize{
 \item{\code{status}: Row names of the \code{cellComparison} object.}
 \item{\code{version}: Column names of the \code{cellComparison} object.}
 \item{\code{count}: Contents of the \code{cellComparison} object.}
}
}
\description{
Versions of a data set can be cellwise compared using
\code{\link{cells}}. The result is a \code{cellComparison} object, 
which can usefully be translated into a data frame.
}
\examples{
data(retailers)

# start with raw data
step0 <- retailers

# impute turnovers
step1 <- step0
step1$turnover[is.na(step1$turnover)] <- mean(step1$turnover,na.rm=TRUE)

# flip sign of negative revenues
step2 <- step1
step2$other.rev <- abs(step2$other.rev)
  

# create an overview of differences, comparing to the previous step
cells(raw = step0, imputed = step1, flipped = step2, compare="sequential")

# create an overview of differences compared to raw data
out <- cells(raw = step0, imputed = step1, flipped = step2)
out

# Graphical overview of the changes
plot(out)
barplot(out)

# transform data to data.frame (easy for use with ggplot)
as.data.frame(out)


}
\seealso{
Other comparing: \code{\link{as.data.frame,validatorComparison-method}},
  \code{\link{barplot,cellComparison-method}},
  \code{\link{barplot,validatorComparison-method}},
  \code{\link{cells}}, \code{\link{compare}},
  \code{\link{match_cells}},
  \code{\link{plot,cellComparison-method}},
  \code{\link{plot,validatorComparison-method}}
}
\concept{comparing}
