% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{validator}
\alias{validator}
\title{Define validation rules for data}
\usage{
validator(..., .file, .data)
}
\arguments{
\item{...}{A comma-separated list of validating expressions}

\item{.file}{(optional) A character vector of file locations (see also the
section on file parsing in the}

\item{.data}{(optional) A \code{data.frame} with columns \code{"rule"},
  \code{"name"}, and \code{"description"}
\code{\link{syntax}} help file).}
}
\value{
An object of class \code{validator} (see \code{\link{validator-class}}).
}
\description{
Define validation rules for data
}
\section{Validating expressions}{

Each validating expression should evaluate to a \code{logical}. Allowed syntax of
the expression is described in \code{\link{syntax}}.


A \emph{validating expression} is an expression whose evaluation results in \code{TRUE}, \code{FALSE}
or \code{NA}.
}

\examples{

v <- validator(
  height>0
  ,weight>0
  ,height < 1.5*mean(height)
)
cf <- confront(women, v)
summary(cf)

}
\seealso{
\itemize{
 \item{\code{\link{syntax}}} 
 \item{\code{\link{confront}}}, \code{\link{check_that}}
 \item{\code{\link{summary,expressionset-method}}}
 \item{\code{\link{validator-class}}}
}
}
