% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{standardize_vald_metadata}
\alias{standardize_vald_metadata}
\title{Create Unified Athlete Metadata with Group Assignments}
\usage{
standardize_vald_metadata(profiles, groups, verbose = TRUE)
}
\arguments{
\item{profiles}{Data frame. Raw profile data from \code{fetch_vald_metadata()}.}

\item{groups}{Data frame. Raw group data from \code{fetch_vald_metadata()}.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A data frame with one row per athlete containing:
  \describe{
    \item{profileId}{Unique athlete identifier}
    \item{givenName, familyName}{Athlete names}
    \item{dateOfBirth, sex}{Demographic information}
    \item{all_group_names}{Comma-separated list of all group memberships}
    \item{all_group_ids}{Comma-separated list of all group IDs}
  }
}
\description{
Processes raw profile and group data to create a clean, analysis-ready metadata
table. Unnests group memberships, concatenates group names, and applies
sports classification logic.
}
\details{
Standardize VALD Metadata
}
\examples{
\donttest{
if (FALSE) {
  metadata <- fetch_vald_metadata(client_id, client_secret, tenant_id)
  clean_metadata <- standardize_vald_metadata(
    profiles = metadata$profiles,
    groups = metadata$groups
  )
}
}
}
