% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_rdbr.R
\name{rdbr}
\alias{rdbr}
\title{Recursive Dependent Binary Relevance (RDBR) for multi-label Classification}
\usage{
rdbr(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  estimate.models = TRUE, ..., cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{estimate.models}{Logical value indicating whether is necessary build
Binary Relevance classifier for estimate process. The default implementation
use BR as estimators, however when other classifier is desirable then use
the value \code{FALSE} to skip this process. (Default: \code{TRUE}).}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{RDBRmodel} containing the set of fitted
 models, including:
 \describe{
   \item{labels}{A vector with the label names.}
   \item{estimation}{The BR model to estimate the values for the labels.
     Only when the \code{estimate.models = TRUE}.}
   \item{models}{A list of final models named by the label names.}
 }
}
\description{
Create a RDBR classifier to predict multi-label data. This is a recursive
approach that enables the binary classifiers to discover existing label
dependency by themselves. The idea of RDBR is running DBR recursively until
the results stabilization of the result.
}
\details{
The train method is exactly the same of DBR the recursion is in the predict
method.
}
\examples{
model <- rdbr(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use Random Forest as base algorithm and 4 cores
model <- rdbr(toyml, 'RF', cores = 4, seed = 123)
}
}
\references{
Rauber, T. W., Mello, L. H., Rocha, V. F., Luchi, D., & Varejao, F. M.
  (2014). Recursive Dependent Binary Relevance Model for Multi-label
  Classification. In Advances in Artificial Intelligence - IBERAMIA, 206-217.
}
\seealso{
\code{\link[=dbr]{Dependent Binary Relevance (DBR)}}

Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}}, \code{\link{esl}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ns}},
  \code{\link{ppt}}, \code{\link{prudent}},
  \code{\link{ps}}, \code{\link{rakel}}, \code{\link{rpc}}
}
\concept{Transformation methods}
