% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ns.R
\name{ns}
\alias{ns}
\title{Nested Stacking for multi-label Classification}
\usage{
ns(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  chain = NA, ..., predict.params = list(), cores = NULL,
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{chain}{A vector with the label names to define the chain order. If
empty the chain is the default label sequence of the dataset. (Default:
\code{NA})}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{predict.params}{A list of default arguments passed to the predict
algorithm. (default: \code{list()})}

\item{cores}{Ignored because this method does not support multi-core.}

\item{seed}{An optional integer used to set the seed.
(Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{NSmodel} containing the set of fitted
  models, including:
  \describe{
   \item{chain}{A vector with the chain order}
   \item{labels}{A vector with the label names in expected order}
   \item{labelset}{The matrix containing only labels values}
   \item{models}{A list of models named by the label names.}
  }
}
\description{
Create a Nested Stacking model for multilabel classification.
}
\details{
Nested Stacking is based on Classifier Chains transformation method to
predict multi-label data. It differs from CC to predict the labels values in
the training step and to regularize the output based on the labelsets
available on training data.
}
\examples{
model <- ns(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use a specific chain with J48 classifier
mychain <- sample(rownames(toyml$labels))
model <- ns(toyml, 'J48', mychain)

# Set a specific parameter
model <- ns(toyml, 'KNN', k=5)
}
}
\references{
Senge, R., Coz, J. J. del, & Hullermeier, E. (2013). Rectifying classifier
   chains for multi-label classification. In Workshop of Lernen, Wissen &
   Adaptivitat (LWA 2013) (pp. 162-169). Bamberg, Germany.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}}, \code{\link{esl}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ppt}},
  \code{\link{prudent}}, \code{\link{ps}},
  \code{\link{rakel}}, \code{\link{rdbr}},
  \code{\link{rpc}}
}
\concept{Transformation methods}
