% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_homer.R
\name{homer}
\alias{homer}
\title{Hierarchy Of Multilabel classifiER (HOMER)}
\usage{
homer(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  clusters = 3, method = c("balanced", "clustering", "random"),
  iteration = 100, ..., cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{clusters}{Number maximum of nodes in each level. (Default: 3)}

\item{method}{The strategy used to organize the labels (create the
meta-labels). The options are: "balanced", "clustering" and "random".
  (Default: "balanced").}

\item{iteration}{The number max of iterations, used by balanced or clustering
methods.}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{HOMERmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{clusters}{The number of nodes in each level}
   \item{models}{The Hierarchy of BR models.}
  }
}
\description{
Create a Hierarchy Of Multilabel classifiER (HOMER).
}
\details{
HOMER is an algorithm for effective and computationally efficient multilabel
classification in domains with many labels. It constructs a hierarchy of
multilabel classifiers, each one dealing with a much smaller set of labels.
}
\examples{
model <- homer(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
##Change default configurations
model <- homer(toyml, "RF", clusters=5, method="clustering", iteration=10)
}
}
\references{
Tsoumakas, G., Katakis, I., & Vlahavas, I. (2008). Effective and efficient
  multilabel classification in domains with large number of labels. In Proc.
  ECML/PKDD 2008 Workshop on Mining Multidimensional Data (MMD'08)
  (pp. 30-44). Antwerp, Belgium.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{ecc}}, \code{\link{eps}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ns}},
  \code{\link{ppt}}, \code{\link{prudent}},
  \code{\link{ps}}, \code{\link{rakel}},
  \code{\link{rdbr}}, \code{\link{rpc}}
}
